// SPON Rangefinder v0.3.0 (Addon version)
//
// Copyright (C) 2007-8 Bil Bas (bil {dot} bagpuss [at] gmail {dot} com / Spooner)
// License: GNU Lesser General Public License, version 3 <http://www.gnu.org/licenses/>

#ifndef SPON_ADDON
#define SPON_ADDON
#endif

// -----------------------------------------------------------------------------
// SPON\Rangefinder\rangefinder.inc.sqf
//
// -----------------------------------------------------------------------------

// Period between checks for the player having a SOFLAM.
#define CHECK_FOR_SOFLAM_INVENTORY_INTERVAL 5

// Standing, crouching and prone with binocs (with rifle, pistol, launcher or unarmed, respectively).
//      ------ Standing ------          ------ Crouching ------           ------ Prone ------
#define ANIM_BINOCS \
[ \
	"awoppercmstpsoptwbindnon_rfl", "awoppknlmstpsoptwbindnon_rfl", "awopppnemstpsoptwbindnon_rfl", \
	"awoppercmstpsoptwbindnon_pst", "awoppknlmstpsoptwbindnon_pst", "awopppnemstpsoptwbindnon_pst", \
	                                "awoppknlmstpsoptwbindnon_lnr", \
	"awoppercmstpsoptwbindnon_non",	                                "awopppnemstpsoptwbindnon_non" \
]

// Value shown before rangefinder is turned on.
#define VALUE_NOT_SHOWN ""

#define DEGREES_TO_MILS(ANGLE,MILS_PER_360) \
	(round(((ANGLE) * MILS_PER_360) / 360) mod MILS_PER_360);

// Check if the NWD optics (ScopeFix) addon is running.
#define NWD_OPTICS_INSTALLED() (isClass (configFile >> "CfgPatches" >> "NWD_ScopeFix"))

#define DEFAULT_MILS_PER_REVOLUTION 6000
#define DEFAULT_POSSIBLE_MILS_PER_REVOLUTION [6000, 6283, 6300, 6400, 360]
#define DEFAULT_SHOW_MAP_MARKER true

#define LASER_TARGET_OWNER_VAR "SPON_RF_owner"

// How to check along the path of the laser. We need quite a wide search,
// since the placement angle of the target and the direction of the binocs are
// not exactly the same.
#define DISTANCE_BETWEEN_CHECKS 75
#define RADIUS_OF_CHECK 125
#define MAX_DISTANCE 10200

#define TARGET_FOUND_EVENT_PRIVATE "SPON_RF_targetFound_INTERNAL"
#define TARGET_FOUND_EVENT_PUBLIC "SPON_RF_targetFound"

#define TARGET_ICON "FireMission"
#define TARGET_ICON_SIZE [0.7, 0.7]

#define TARGET_MARKER "SPON_RF_target_%1"

#define DEFAULT_LD_CLASS "LaserDesignator"
